#ifndef M_PI
#define M_PI  (3.14159265)
#endif

#ifndef SAMPLETABLE_H
#define SAMPLETABLE_H

#include <vector>
#include "Table.h"
#include <string>
#include <sndfile.h>
#include <cmath>
#include <iostream>

using std::vector;
using std::string;
using std::cout; 
using std::endl;

class SampleTable : public Table{
public:
    explicit SampleTable(){}
    SampleTable(const char *path){
		mFilePath = path;
		if(!InitializeWavetable()){
			cout << "Unable to read " << path << endl;
		}
	}
	SampleTable(const std::string & path){
        mFilePath = path.c_str();
		if(!InitializeWavetable()){
			cout << "Unable to read " << path << endl;
		}
    }
    SampleTable(const float * array, int length){
        mTable = std::vector<float>(length,0);
      for(int i=0; i < length; i++){
        mTable.at(i)=array[i];
      }
    }
    SampleTable(const std::vector<float> & v){
        mTable=v;
    }	
    
    //interpolation
	float amplitudeViaPhase(double phase) const{
        int tableSize = (int)mTable.size();
    	return linearInterpolation(mTable.at((int)floor(tableSize*phase)),
                                   mTable.at((int)ceil(tableSize*phase)%tableSize),
                                   tableSize*phase-floor(tableSize*phase));
    } 	
    //interpolation
    float amplitudeViaSample(double sample) const{
        return linearInterpolation(mTable.at((int)floor(sample)),mTable.at((int)ceil(sample)%mTable.size()),sample-floor(sample));
    } 
    //no interpolation
    float amplitudeViaSample(int sample) const{
        return mTable.at(sample);
    } 
    int length() const{return (int)mTable.size();}    
	float freq(){return mFrequency;}
    void Resize(int tableSize){
        mTable.resize(tableSize,0);
    }
private:
	const char * mFilePath;
	float mFrequency;
    std::vector<float> mTable;
    
	void WriteArrayToBufferVector(const float *array, int length){
		cout << "size of table: " << mTable.size() << endl;
		for(int i=0; i < length; i++){
			mTable.at(i)=array[i];
		}
	}
    float linearInterpolation(float a, float b, float distance) const{
		//distance is 0 to 1
		return a + (b-a)*distance;
	}
    bool InitializeWavetable(){
		SNDFILE *infile; 
        SF_INFO sfinfo;
        
		//path is dir plus file name
		if (! (infile = sf_open (mFilePath, SFM_READ, &sfinfo))){   
			printf ("Not able to open input file %s.\n", mFilePath);
			puts (sf_strerror (NULL)); //Print the error message from libsndfile
			return false;
		}
		cout << "\nSuccessful read of " << mFilePath << endl;
		cout << "channels: " << sfinfo.channels << endl;
		cout << "sample rate: " << sfinfo.samplerate << endl;
		cout << "format: " << sfinfo.format << endl;
		cout << "frames: " << sfinfo.frames << endl;
		long tableSize = sfinfo.frames;
		
		mFrequency = sfinfo.samplerate / tableSize;
		mTable = std::vector<float>(tableSize);
		float temp[tableSize];
		
		//While there are.frames in the input file, read them.    
		sf_read_float(infile, temp, tableSize);
		WriteArrayToBufferVector(temp,(int)tableSize);
		sf_close (infile) ;
		
		return true;
	}
};

#endif
