
#ifndef SPECTRUM_H
#define SPECTRUM_H

class Partial{
public:
    Partial(float frequency, float amplitude){
        mFrequency=frequency;
        mAmplitude=amplitude;
    }
    float& frequency() { return mFrequency; }
    float& amplitude() { return mAmplitude; }
    const float frequency() const {return mFrequency;}
    const float amplitude() const {return mAmplitude;}
private:
    float mFrequency;
    float mAmplitude;
};
bool operator<(Partial const & a, Partial const & b){
    //for the purposes of sorting via magnitude of amplitude in descending order
    if(abs(a.amplitude()) > abs(b.amplitude())) return true;
    return false;
}

class Spectrum{
    
public:
    
    Spectrum(VECTOR const & eigenvalues, MATRIX const & eigenvectors, VECTOR const & initialState){        
        //for each eigenvalue, add a partial to the list
        for(int i=0; i<eigenvalues.size(); i++){
            mPartials.push_back(Partial(sqrt(eigenvalues(i))/(M_2_PI),eigenvectors.column(i)*initialState));
        }
        //sort partials in descending order according to magnitude of starting amplitude
        //sort(mPartials.begin(),mPartials.end());
    }
    float& frequency(int i) { return mPartials.at(i).frequency(); };
    float& amplitude(int i) { return mPartials.at(i).amplitude(); };
    const float frequency(int i) const { return mPartials.at(i).frequency(); };
    const float amplitude(int i) const { return mPartials.at(i).amplitude(); };
    
    float sumOfFirstNAmplitudeMagnitudes(int n) const{
        float sum=0;
        for(int i=0; i<n; i++){
            sum+=abs(amplitude(i));
        }
        return sum;
    }
private:
    std::vector<Partial> mPartials;
};

#endif
