//modified patest_sine.c
//by Ross Bencina and Phil Burk
//$Id: patest_sine.c 1097 2006-08-26 08:27:53Z rossb $


#ifndef AUDIO_H
#define AUDIO_H

#include "portaudio.h"
#include "SoundSource.h"

static float MASTER_GAIN;

class Audio{
    
public:
    
    Audio(){}
    PaError Initialize(int numChannels){
        mError = Pa_Initialize();  
        if( mError != paNoError ){ HandleError(); return mError; }
        SetOutputParameters(numChannels);
        return mError;
    }
    PaError OpenStream(int sampleRate, int framesPerBuffer, SoundSource & soundSource, float masterGain){
        MASTER_GAIN = masterGain;
        
        mError = Pa_OpenStream(
                               &mStream, NULL /* no input */, &mOutputParameters,
                               sampleRate, framesPerBuffer,
                               paClipOff, audioCallback, &soundSource);
        
        if( mError != paNoError ){ HandleError(); return mError;}
        
        RegisterStreamFinishedCallback();
        
        if( mError != paNoError ){ HandleError(); return mError; }
        
        return mError; //should equal 0 (paNoError) at this point
    }
    PaError RunStreamForDuration(int seconds){
        
        //Start stream
        mError = Pa_StartStream( mStream );
        if( mError != paNoError ){ HandleError(); return mError;}
		
        //Wait for pre-specified run duration
        Pa_Sleep( seconds * 1000 );
        
        //Stop the stream
        mError = Pa_StopStream( mStream );
        if( mError != paNoError ){ HandleError(); return mError;}
        
        //Close the stream
        mError = Pa_CloseStream( mStream );
        if( mError != paNoError ){ HandleError(); return mError;}
        
        Pa_Terminate();
        
        return mError;
    }
private:
    PaStreamParameters mOutputParameters;
    PaStream *mStream;
    PaError mError;
    
    static int audioCallback( const void *inputBuffer, void *outputBuffer,
                             unsigned long framesPerBuffer,
                             const PaStreamCallbackTimeInfo* timeInfo,
                             PaStreamCallbackFlags statusFlags,
                             void *userData ){
        
        //to avoid compiler warnings:
        (void) timeInfo; (void) statusFlags; (void) inputBuffer;
        
        SoundSource * soundSource = (SoundSource*)userData;        
        
        //the vector is totalChannels * FramesPerBuffer in length
        std::vector<float> interlacedBuffer = soundSource->fillBuffer((int)framesPerBuffer);
        
        float *out = (float*)outputBuffer;
        
        for (std::vector<float>::iterator buffIt = interlacedBuffer.begin(); buffIt!=interlacedBuffer.end(); buffIt++) {
            *out++ = MASTER_GAIN*(*buffIt);
        }
        soundSource->ResetVisitedStatus();
        return paContinue;
    }
    void HandleError() const{
        Pa_Terminate();
        fprintf( stderr, "An error occured while using the portaudio stream\n" );
        fprintf( stderr, "Error number: %d\n", mError );
        fprintf( stderr, "Error message: %s\n", Pa_GetErrorText( mError ) );
    }
    void SetOutputParameters(int numChannels){
        mOutputParameters.device = Pa_GetDefaultOutputDevice(); /* default output device */
        mOutputParameters.channelCount = numChannels;       /* n-channel output */
        mOutputParameters.sampleFormat = paFloat32; /* 32 bit floating point output */
        mOutputParameters.suggestedLatency = Pa_GetDeviceInfo( mOutputParameters.device )->defaultLowOutputLatency;
        mOutputParameters.hostApiSpecificStreamInfo = NULL;	
    }
    
    static void StreamFinished( void* userData ){
        //printf( "Stream Completed: %s\n", data->getMessage() );
    }
    void RegisterStreamFinishedCallback(){
        //Register stream finished callback.  
        mError = Pa_SetStreamFinishedCallback( mStream, &StreamFinished );
    }
};


#endif
