#ifndef MONOTOSTEREO_H
#define MONOTOSTEREO_H

#include <vector>
#include "SoundSource.h"

class MonoToStereo : public SoundSource{
public:
    explicit MonoToStereo(){};
	MonoToStereo(SoundSource * monoSource, int bufferCapacity){
		source = monoSource;
		monoBuffer = std::vector<float>(bufferCapacity);
		interlacedStereoBuffer = std::vector<float>(2*bufferCapacity);
        mVisited = false;
	}	
	std::vector<float> fillBuffer(int frames){
		if(!mVisited){
            monoBuffer = source->fillBuffer(frames);
            for(int i=0; i<frames; i++){
                interlacedStereoBuffer[2*i+1]=interlacedStereoBuffer[2*i]=monoBuffer[i];
            }
            mVisited = true;
        }
        
		return interlacedStereoBuffer;
	}
    void ResetVisitedStatus(){
        if(mVisited){
            source->ResetVisitedStatus();
            mVisited = false;
        }
    }
private:
	SoundSource * source;
	std::vector<float> monoBuffer;
	std::vector<float> interlacedStereoBuffer;
    bool mVisited;
};

#endif
