
#ifndef SAMPLEPLAYER_H
#define SAMPLEPLAYER_H

#include "Audio.h"
#include "SampleTable.h"
#include "MonoToStereo.h"
#include "TabPlay.h"

class SamplePlayer{
public:
    SamplePlayer(){}
    void LoadSample(int sampleRate, int framesPerBuffer, float gain, std::vector<float> waveform){
        
        mSampleRate=sampleRate;
        mFramesPerBuffer=framesPerBuffer;
        mGain=gain;
        mSampleTable = SampleTable(waveform);
        mTabPlay = TabPlay(framesPerBuffer,&mSampleTable,false);
        mAudio = Audio();
        mMonoToStereo = MonoToStereo(&mTabPlay,framesPerBuffer);
    }
    void Play(float duration){
        mAudio.Initialize(2); //stereo
        mAudio.OpenStream(mSampleRate,mFramesPerBuffer,mMonoToStereo,mGain); 
        mAudio.RunStreamForDuration( duration < 1.0 ? 1.0 : duration);
    }
private:
    Audio mAudio;
    MonoToStereo mMonoToStereo; //upmixes to stereo from mono
    SampleTable mSampleTable;
    TabPlay mTabPlay;
    int mSampleRate;
    int mFramesPerBuffer;
    float mGain;
};

#endif
