
#ifndef TABPLAY_H
#define TABPLAY_H

#include <vector>
#include "SampleTable.h"
#include "SoundSource.h"

class TabPlay: public SoundSource{
public:
    
    explicit TabPlay(){}
    
	TabPlay(int framesPerBuffer, SampleTable * table, bool repeat)
    :mBuffer(framesPerBuffer,0){
		wavetable = table;
		currentSample = 0;
        mRepeat = repeat;
        mVisited = false;
	}	
    
    void ResetVisitedStatus(){ mVisited = false; }
	
    std::vector<float> fillBuffer(int frames){
		if(!mVisited){
            for(int i=0; i < frames; i++){
                if(currentSample >= wavetable->length()){
                    if(mRepeat){
                        //wrap phase before retrieving samples
                        currentSample -= wavetable->length();
                        mBuffer.at(i)=wavetable->amplitudeViaSample(currentSample);
                        currentSample++;
                    }
                    else{
                        //return silence
                        mBuffer.at(i)=0;
                    }
                }
                else{
                    //retrieve samples
                    mBuffer.at(i)=wavetable->amplitudeViaSample(currentSample);
                    currentSample++; 
                }
            }	
            mVisited = true;
        }
		return mBuffer;
	}
private:
	SampleTable * wavetable;
	int currentSample;
    std::vector<float> mBuffer;
    bool mRepeat;
    bool mVisited;
};

#endif
